/* ---------------------------------------------------------------------------
   © 2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.
 
   This program is an unpublished copyrighted work which is proprietary
   to HID Global. This computer program includes Confidential,
   Proprietary Information and is a Trade Secret of HID Global.
   Any use, disclosure, modification and/or reproduction is prohibited
   unless authorized in writing by HID Global.

   WARNING:  Unauthorized reproduction of this program as well as
   unauthorized preparation of derivative works based upon the
   program or distribution of copies by sale, rental, lease or
   lending are violations of federal copyright laws and state trade
   secret laws, punishable by civil and criminal penalties.
--------------------------------------------------------------------------- */

#ifndef __AIPKCS_H_
#define __AIPKCS_H_

#if defined(WIN32) || defined(WIN64) || defined(WINCE)
// Windows standard files and definitions 
#include <windows.h>
#endif

#if defined(WIN32) || defined(WIN64) || defined(WINCE)

#pragma pack(push, cryptoki, 1)
#define CK_DEFINE_FUNCTION(returnType, name) \
returnType __declspec(dllexport) name
#define CK_DECLARE_FUNCTION(returnType, name)  \
returnType __declspec(dllexport) name
#define CK_DECLARE_FUNCTION_POINTER(returnType, name) \
returnType __declspec(dllimport) (* name)
#define CK_CALLBACK_FUNCTION(returnType, name) \
returnType (* name)

#else /* Unix & VxWorks */
#if defined(__GNUC__) && __GNUC__ >= 4
#define CK_DEFINE_FUNCTION(returnType, name) returnType __attribute ((visibility("default"))) name
#define CK_DECLARE_FUNCTION(returnType, name) returnType __attribute ((visibility("default"))) name
#else
#define CK_DEFINE_FUNCTION(returnType, name) returnType name
#define CK_DECLARE_FUNCTION(returnType, name) returnType name
#endif
#define CK_DECLARE_FUNCTION_POINTER(returnType, name) returnType (* name)
#define CK_CALLBACK_FUNCTION(returnType, name) returnType (* name)
#endif

#define CK_PTR *
#ifndef NULL_PTR
#define NULL_PTR 0
#endif

#include "pkcs11.h"

/** \addtogroup HID_Global_Middleware */
/** @{ */
/**
 * \defgroup HID_Global_Middleware_PKCS11 HID Global Additions to PKCS11
 * This section documents the HID Global additions to PKCS11. Functions added
 * by HID Global are not listed by C_GetFunctionList.
 */
/** @{ */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Resets the token, deleting all the objects.
 * \param [in] hSession A R/W session handle.
 * \return CKR_OK if successful.
 * \details This function only applies to some specific card profiles and
 * may not be implemented.
 */
CK_DECLARE_FUNCTION(CK_RV, C_ResetToken)(CK_SESSION_HANDLE hSession);

/**
 * \brief Unlocks the PIN when too many login attempts failed and sets a new PIN.
 * \param [in] hSession A session handle.
 * \param [in] pUnlockCode A pointer to the unlock code.
 * \param [in] ulUnlockCodeLength The length in bytes of the unlock code.
 * \param [in] pNewPinCode A pointer to the new PIN code to be set.
 * \param [in] ulNewPinCodeLength The length in bytes of the new PIN.
 * \return CKR_OK if successful.
 * \details This function only applies to some specific card profiles and
 * may not be implemented.
 */
CK_DECLARE_FUNCTION(CK_RV, C_UnlockPIN)(CK_SESSION_HANDLE	hSession, 
								CK_CHAR_PTR			pUnlockCode,
								CK_ULONG			ulUnlockCodeLength,
								CK_CHAR_PTR			pNewPinCode, 
								CK_ULONG			ulNewPinCodeLength);

/**
 * \deprecated Use \a C_GetCUID instead.
 */
CK_DECLARE_FUNCTION(CK_RV, C_CetCUID)(	CK_SLOT_ID			slotID,
										CK_CHAR_PTR			pCUID,
										CK_ULONG_PTR		pulCUIDLength
										);

/**
 * \brief Gets a Card Unique Identifier (CUID).
 * \param [in] slotId The identifier of the slot where the card is inserted.
 * \param [out] pCUID A pointer to a buffer receiving the CUID. The buffer must
 *                    be large enough to receive the CUID. If NULL, it is ignored
 *                    and \a pulCUIDLength receives the effective length of the CUID.
 * \param [in,out] pulCUIDLength On input, length in bytes of the buffer receiving the 
 *                               CUID. On output, effective length of the CUID. It
 *                               cannot be NULL. If \a pCUID is not NULL and the
 *                               length is not large enough, the function returns
 *                               CKR_BUFFER_TOO_SMALL.
 * \return CRK_OK if successful.
 * \details The CUID is computed based on the smart card contents. It may differ from a 
 * card vendor to another.
 */
CK_DECLARE_FUNCTION(CK_RV, C_GetCUID)(	CK_SLOT_ID			slotID,
										CK_CHAR_PTR			pCUID,
										CK_ULONG_PTR		pulCUIDLength
										);

/**
 * \brief Initializes an Unblock PIN verification operation.
 * \param [in] hSession A session handle.
 * \param [in] pMechanism The unlock PIN mechanism.
 * \param [in] hKey Handle of unlock PIN key.
 * \return CKR_OK if successful.
 * \details This function only applies to some specific card profiles and
 * may not be implemented.
 */
CK_DECLARE_FUNCTION(CK_RV, C_VerifyUnblockPINInit)(	CK_SESSION_HANDLE	hSession, 
													CK_MECHANISM_PTR	pMechanism,
													CK_OBJECT_HANDLE	hKey);

/**
 * \brief Verifies the unblock code supplied in a single-part operation.
 * \param [in] hSession A session handle.
 * \param [in] pPIN The new user's PIN.
 * \param [in] ulPinLen Length of the new users's PIN.
 * \param [in] pSignature The unblock code.
 * \param [in] ulSignatureLen Length of the unblock code.
 * \return CKR_OK if successful.
 * \details This function only applies to some specific card profiles and
 * may not be implemented.
 */
CK_DECLARE_FUNCTION(CK_RV, C_VerifyUnblockPIN)(	CK_SESSION_HANDLE	hSession,
												CK_UTF8CHAR_PTR		pPIN,
												CK_ULONG			ulPinLen,
												CK_BYTE_PTR			pSignature, 
												CK_ULONG			ulSignatureLen);

#ifdef __cplusplus
}
#endif

/**
 * \defgroup HID_Global_Middleware_PKCS11_Objects HID Global defined objects
 * @{
 */
#define CKO_ACTI                  (CKO_VENDOR_DEFINED + 0x800) /**< HID Global Objects id starting index */

#define CKO_CHUID                 (CKO_ACTI + 0) /**< Card Holder Unique Identifier. */
#define CKO_FACIAL_IMAGE          (CKO_ACTI + 1) /**< Facial image of the card holder. */
#define CKO_FINGERPRINTS          (CKO_ACTI + 2) /**< Fingerprints samples of the card holder. */
#define CKO_PRINTED_INFO          (CKO_ACTI + 3) /**< Digital copy of the information printed on the card surface. */
#define CKO_SECURITY_OBJECT       (CKO_ACTI + 4) /**< Security object. */
#define CKO_DISCOVERY_OBJECT      (CKO_ACTI + 5) /**< Discovery object. */
#define CKO_CCC                   (CKO_ACTI + 6) /**< Card Capability Container. */
#define CKO_KEY_HISTORY           (CKO_ACTI + 7) /**< Key history. */
#define CKO_IRIS_IMAGE            (CKO_ACTI + 8) /**< Iris image of the card holder. */

#define CKO_UNBLOCK_PIN           (CKO_ACTI + 10) /**< Unlock PIN object. */
/** @} */

/**
 * \defgroup HID_Global_Middleware_PKCS11_Attributes HID Global defined attributes
 * @{
 */
#define CKA_CONTAINER_NAME									(CKA_VENDOR_DEFINED+0x8)	///< CryptoAPI key container name
#define CKA_PRIVATE_KEY_PRESENT								(CKA_VENDOR_DEFINED+0x100)	///< Obsolete.
#define	CKA_EXTENDED_KEY_USAGE_SMARTCARD_LOGON				(CKA_VENDOR_DEFINED+0x102)	///< Certificate and private key attribute indicating
																						///< whether extended key usage allows smart card logon.
#define CKA_CHUID_GUID										(CKA_VENDOR_DEFINED+0x200)
#define CKA_CHUID_EXPIRATION_DATE							(CKA_CHUID_GUID + 1)
#define CKA_CHUID_OPT_AGENCY								(CKA_CHUID_GUID + 2)
#define CKA_CHUID_OPT_ORGANIZATION							(CKA_CHUID_GUID + 3)
#define CKA_CHUID_OPT_DUNS									(CKA_CHUID_GUID + 4)
#define CKA_CHUID_FASCN										(CKA_CHUID_GUID + 15)
#define CKA_CHUID_FASCN_AGENCY								(CKA_CHUID_GUID + 16)
#define CKA_CHUID_FASCN_SYSTEM								(CKA_CHUID_GUID + 17)
#define CKA_CHUID_FASCN_CREDENTIAL_NUMBER					(CKA_CHUID_GUID + 5)
#define CKA_CHUID_FASCN_CREDENTIAL_SERIES					(CKA_CHUID_GUID + 6)
#define CKA_CHUID_FASCN_INDIVIDUAL_CREDENTIAL_ISSUE			(CKA_CHUID_GUID + 7)
#define CKA_CHUID_FASCN_PERSON_IDENTIFIER					(CKA_CHUID_GUID + 8)
#define CKA_CHUID_FASCN_ORGANIZATIONAL_CATEGORY				(CKA_CHUID_GUID + 9)
#define CKA_CHUID_FASCN_ORGANIZATIONAL_IDENTIFIER			(CKA_CHUID_GUID + 10)
#define CKA_CHUID_FASCN_PERSON_ASSOCIATION_CATEGORY			(CKA_CHUID_GUID + 11)
#define CKA_CHUID_SIGNATURE									(CKA_CHUID_GUID + 12)
#define CKA_CHUID_SIGNATURE_STATUS							(CKA_CHUID_GUID + 13)
#define CKA_CHUID_SIGNER_CERTIFICATE						(CKA_CHUID_GUID + 14)

#define CKA_FACIAL_IMAGE_CBEFF_HEADER                       (CKA_VENDOR_DEFINED+0x230)
#define CKA_FACIAL_IMAGE_CBEFF_RECORD						(CKA_FACIAL_IMAGE_CBEFF_HEADER + 1)
#define CKA_FACIAL_IMAGE_CBEFF_SIGNATURE					(CKA_FACIAL_IMAGE_CBEFF_HEADER + 2)
#define CKA_FACIAL_IMAGE_SIGNATURE_STATUS					(CKA_FACIAL_IMAGE_CBEFF_HEADER + 3)
#define CKA_FACIAL_IMAGE_SIGNER_CERTIFICATE					(CKA_FACIAL_IMAGE_CBEFF_HEADER + 4)
#define CKA_FACIAL_IMAGE_FASCN								(CKA_FACIAL_IMAGE_CBEFF_HEADER + 5)
#define CKA_FACIAL_IMAGE_UUID								(CKA_FACIAL_IMAGE_CBEFF_HEADER + 6)

#define CKA_FINGERPRINTS_CBEFF_HEADER						(CKA_VENDOR_DEFINED+0x260) 
#define CKA_FINGERPRINTS_CBEFF_RECORD						(CKA_FINGERPRINTS_CBEFF_HEADER + 1)
#define CKA_FINGERPRINTS_CBEFF_SIGNATURE					(CKA_FINGERPRINTS_CBEFF_HEADER + 2)
#define CKA_FINGERPRINTS_SIGNATURE_STATUS					(CKA_FINGERPRINTS_CBEFF_HEADER + 3)
#define CKA_FINGERPRINTS_SIGNER_CERTIFICATE					(CKA_FINGERPRINTS_CBEFF_HEADER + 4)
#define CKA_FINGERPRINTS_FASCN								(CKA_FINGERPRINTS_CBEFF_HEADER + 5)
#define CKA_FINGERPRINTS_UUID								(CKA_FINGERPRINTS_CBEFF_HEADER + 6)

#define CKA_PRINTED_INFORMATION_NAME								(CKA_VENDOR_DEFINED+0x290)
#define CKA_PRINTED_INFORMATION_EMPLOYEE_AFFILIATION 				(CKA_PRINTED_INFORMATION_NAME + 1)	// = CKA_PRINTED_INFORMATION_EMPLOYEE_INFORMATION_LINE1
#define CKA_PRINTED_INFORMATION_EMPLOYEE_INFORMATION_LINE1			(CKA_PRINTED_INFORMATION_NAME + 1)
#define CKA_PRINTED_INFORMATION_EMPLOYEE_INFORMATION_LINE2			(CKA_PRINTED_INFORMATION_NAME + 2)
#define CKA_PRINTED_INFORMATION_EXPIRATION_DATE						(CKA_PRINTED_INFORMATION_NAME + 3)
#define CKA_PRINTED_INFORMATION_AGENCY_CARD_SERIAL_NUMBER			(CKA_PRINTED_INFORMATION_NAME + 4)
#define CKA_PRINTED_INFORMATION_ISSUER_IDENTIFICATION				(CKA_PRINTED_INFORMATION_NAME + 5)
#define CKA_PRINTED_INFORMATION_ORGANIZATION_AFFILIATION_LINE1		(CKA_PRINTED_INFORMATION_NAME + 6)
#define CKA_PRINTED_INFORMATION_ORGANIZATION_AFFILIATION_LINE2		(CKA_PRINTED_INFORMATION_NAME + 7)

#define CKA_SECURITY_OBJECT_MAPPING_OF_DG_TO_CONTAINERID	(CKA_VENDOR_DEFINED+0x2C0)
#define CKA_SECURITY_OBJECT									(CKA_SECURITY_OBJECT_MAPPING_OF_DG_TO_CONTAINERID + 1)
#define CKA_SECURITY_OBJECT_SIGNATURE						(CKA_SECURITY_OBJECT_MAPPING_OF_DG_TO_CONTAINERID + 2)

#define CKA_DISCOVERY_OBJECT_PIV_CARD_APPLICATION_AID		(CKA_VENDOR_DEFINED+0x300)
#define CKA_DISCOVERY_OBJECT_PIN_USAGE_POLICY				(CKA_DISCOVERY_OBJECT_PIV_CARD_APPLICATION_AID + 1)

#define CKA_KEY_HISTORY_OBJECT_KEYS_WITH_ON_CARD_CERTS		(CKA_VENDOR_DEFINED+0x3C0)
#define CKA_KEY_HISTORY_OBJECT_KEYS_WITH_OFF_CARD_CERTS		(CKA_KEY_HISTORY_OBJECT_KEYS_WITH_ON_CARD_CERTS + 1)
#define CKA_KEY_HISTORY_OBJECT_OFF_CARD_CERT_URL			(CKA_KEY_HISTORY_OBJECT_KEYS_WITH_ON_CARD_CERTS + 2)

#define CKA_IRIS_IMAGE_CBEFF_HEADER							(CKA_VENDOR_DEFINED+0x360)
#define CKA_IRIS_IMAGE_CBEFF_RECORD							(CKA_IRIS_IMAGE_CBEFF_HEADER + 1)
#define CKA_IRIS_IMAGE_CBEFF_SIGNATURE						(CKA_IRIS_IMAGE_CBEFF_HEADER + 2)
#define CKA_IRIS_IMAGE_SIGNATURE_STATUS						(CKA_IRIS_IMAGE_CBEFF_HEADER + 3)
#define CKA_IRIS_IMAGE_SIGNER_CERTIFICATE					(CKA_IRIS_IMAGE_CBEFF_HEADER + 4)
#define CKA_IRIS_IMAGE_FASCN								(CKA_IRIS_IMAGE_CBEFF_HEADER + 5)
#define CKA_IRIS_IMAGE_UUID									(CKA_IRIS_IMAGE_CBEFF_HEADER + 6)

#define CKA_CCC_CARD_IDENTIFIER							(CKA_VENDOR_DEFINED+0x390)
#define CKA_CCC_CAPABILITY_CONTAINER_VERSION			(CKA_CCC_CARD_IDENTIFIER + 1)
#define CKA_CCC_CAPABILITY_GRAMMAR_VERSION				(CKA_CCC_CARD_IDENTIFIER + 2)
#define CKA_CCC_APPLICATION_CARDURL_LIST				(CKA_CCC_CARD_IDENTIFIER + 3)
#define CKA_CCC_PKCS15									(CKA_CCC_CARD_IDENTIFIER + 4)
#define CKA_CCC_DATA_MODEL								(CKA_CCC_CARD_IDENTIFIER + 5)
#define CKA_CCC_ACR_TABLE								(CKA_CCC_CARD_IDENTIFIER + 6)
#define CKA_CCC_CARD_APDUS								(CKA_CCC_CARD_IDENTIFIER + 7)
#define CKA_CCC_REDIRECTION_TAG							(CKA_CCC_CARD_IDENTIFIER + 8)
#define CKA_CCC_CAPABILITY_TUPLES						(CKA_CCC_CARD_IDENTIFIER + 9)
#define CKA_CCC_STATUS_TUPLES							(CKA_CCC_CARD_IDENTIFIER + 10)
#define CKA_CCC_NEXT_CCC								(CKA_CCC_CARD_IDENTIFIER + 11)
#define CKA_CCC_EXTENDED_APPLICATION_CARDURL_LIST		(CKA_CCC_CARD_IDENTIFIER + 12)
#define CKA_CCC_SECURITY_OBJECT							(CKA_CCC_CARD_IDENTIFIER + 13)

// Proprietary OTP key attributes
#define CKA_OTP_DERIVATION								(CKA_VENDOR_DEFINED + 0x330)
#define CKA_OTP_COUNTER_INCREMENT						(CKA_OTP_DERIVATION + 1)

// Proprietary Unblock PIN object attributes
#define CKA_UNBLOCK_PIN_CHALLENGE_REQUIREMENT			(CKA_VENDOR_DEFINED + 0x340)
#define CKA_UNBLOCK_PIN_CHALLENGE						(CKA_UNBLOCK_PIN_CHALLENGE_REQUIREMENT + 1)

/** @} */

/**
 * \defgroup HID_Global_Middleware_PKCS11_Flags HID Global defined mechanisms
 * @{
 */

 // Proprietary VerifyUnblockPIN mechanism
#define CKM_UNBLOCK_PIN_STATIC							(CKM_VENDOR_DEFINED + 0x801)
#define CKM_UNBLOCK_PIN_DYNAMIC							(CKM_UNBLOCK_PIN_STATIC + 1)
/** @} */

/**
 * \defgroup HID_Global_Middleware_PKCS11_Flags HID Global defined flags
 * @{
 */
#define CKF_VENDOR_DEFINED        0x80000000

#define CKF_ACTI                  (CKF_VENDOR_DEFINED | 0x01000000)

/**
 * HID Global flag for C_Initialize to enable FIPS mode
 */
#define CKF_ACTI_FIPS_MODE        (CKF_ACTI | 0x00000001)
/** @} */

/**
 * \defgroup HID_Global_Middleware_PKCS11_Errors HID Global defined errors
 * @{
 */
#define CKR_ACTI                  (CKR_VENDOR_DEFINED | 0x01000000)

/**
 * Failed to initialize PKCS 11 for FIPS mode
 */
#define CKR_ACTI_FIPS_MODE_FAILED (CKR_ACTI | 0x00000001)
/** @} */

/** @} */
/** @} */
#if defined(WIN32) || defined(WIN64) || defined(WINCE)
 #pragma pack(pop, cryptoki)
#endif

#endif  // __AIPKCS_H_
